/*
 * Decompiled with CFR 0.152.
 */
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;

public class Evaluate
implements ComputeData {
    static final int IS_NUMBER = 1;
    static final int IS_LETTER = 2;
    static final int IS_LEFT = 4;
    static final int IS_RIGHT = 8;
    static final int IS_SPACE = 16;
    static final int IS_OTHERS = 32;
    static final int REAL_NUMBER = 1;
    static final int RETURN_NUMBER = 2;
    static final int NOT_NUMBER = 4;
    private Hashtable hash;
    private String postfix = null;
    private String expression = "0";
    private String errorMessage = "No error !";
    private boolean isDegree = false;
    private double x = 0.0;
    private double lastAnswer = 0.0;
    public EvaluateData[] functionTable;

    public void setExpression(String string) {
        this.expression = string.toLowerCase();
        this.analysis();
    }

    public String getError() {
        return this.errorMessage;
    }

    public String getPostfix() {
        if (this.postfix == null) {
            this.analysis();
        }
        return this.postfix;
    }

    public void setX(double d) {
        this.x = d;
    }

    public double getX() {
        return this.x;
    }

    public void setDegreeState(boolean bl) {
        this.isDegree = bl;
    }

    private int classify(char c) {
        if (Character.isLetter(c)) {
            return 2;
        }
        if (Character.isDigit(c) || c == '.') {
            return 1;
        }
        if (Character.isWhitespace(c)) {
            return 16;
        }
        if (c == '(') {
            return 4;
        }
        if (c == ')') {
            return 8;
        }
        return 32;
    }

    private void SyntaxError(String string) {
        this.errorMessage = "Syntax error" + (string == null ? " !" : " : " + string + " !");
        throw new NumberFormatException(this.errorMessage);
    }

    private void MethodError(String string) {
        this.errorMessage = string + " is not define !";
        throw new NoSuchMethodError(this.errorMessage);
    }

    public double getValue(double d) {
        this.x = d;
        return this.getValue();
    }

    public double getValue() {
        double d = 0.0;
        Stack<Double> stack = new Stack<Double>();
        EvaluateData evaluateData = null;
        Double[] doubleArray = new Double[2];
        int n = 0;
        while (n < 2) {
            doubleArray[n] = new Double(0.0);
            ++n;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.postfix);
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (this.classify(string.charAt(0)) == 1) {
                stack.push(new Double(string));
                evaluateData = null;
            } else {
                evaluateData = (EvaluateData)this.hash.get(string);
            }
            if (evaluateData != null && evaluateData.operator > stack.size()) {
                this.SyntaxError(string);
            }
            if (evaluateData == null) continue;
            n = 0;
            while (n < evaluateData.operator) {
                doubleArray[n] = (Double)stack.pop();
                ++n;
            }
            switch (evaluateData.id) {
                case 15: {
                    d = doubleArray[0];
                    if (this.isDegree) {
                        d = d * Math.PI / 180.0;
                    }
                    d = Math.sin(d);
                    break;
                }
                case 5: {
                    d = doubleArray[0];
                    if (this.isDegree) {
                        d = d * Math.PI / 180.0;
                    }
                    d = Math.cos(d);
                    break;
                }
                case 18: {
                    d = doubleArray[0];
                    if (this.isDegree) {
                        d = d * Math.PI / 180.0;
                    }
                    d = Math.tan(d);
                    break;
                }
                case 3: {
                    d = doubleArray[0];
                    d = Math.asin(d);
                    if (!this.isDegree) break;
                    d = d * 180.0 / Math.PI;
                    break;
                }
                case 0: {
                    d = doubleArray[0];
                    d = Math.acos(d);
                    if (!this.isDegree) break;
                    d = d * 180.0 / Math.PI;
                    break;
                }
                case 4: {
                    d = doubleArray[0];
                    d = Math.atan(d);
                    if (!this.isDegree) break;
                    d = d * 180.0 / Math.PI;
                    break;
                }
                case 7: {
                    d = doubleArray[0];
                    d = Math.exp(d);
                    break;
                }
                case 8: {
                    d = doubleArray[0];
                    d = Math.log(d);
                    break;
                }
                case 16: {
                    d = doubleArray[0];
                    d = Math.sqrt(d);
                    break;
                }
                case 13: {
                    d = doubleArray[0];
                    double d2 = doubleArray[1];
                    d = Math.pow(d2, d);
                    break;
                }
                case 14: {
                    d = Math.PI;
                    break;
                }
                case 19: {
                    d = this.x;
                    break;
                }
                case 1: {
                    d = doubleArray[0];
                    double d2 = doubleArray[1];
                    d += d2;
                    break;
                }
                case 17: {
                    d = doubleArray[0];
                    double d2 = doubleArray[1];
                    d = d2 - d;
                    break;
                }
                case 11: {
                    d = doubleArray[0];
                    double d2 = doubleArray[1];
                    d = d2 * d;
                    break;
                }
                case 6: {
                    d = doubleArray[0];
                    double d2 = doubleArray[1];
                    d = d2 / d;
                    break;
                }
                case 9: {
                    d = doubleArray[0];
                    d = Math.log(d) / Math.log(10.0);
                    break;
                }
                case 2: {
                    d = this.lastAnswer;
                    break;
                }
                case 10: {
                    d = doubleArray[0];
                    double d2 = doubleArray[1];
                    d = Math.IEEEremainder(d2, d);
                    break;
                }
                case 12: {
                    d = -doubleArray[0].doubleValue();
                    break;
                }
            }
            stack.push(new Double(d));
        }
        if (stack.size() == 1) {
            d = (Double)stack.pop();
        } else {
            this.SyntaxError(null);
        }
        this.lastAnswer = d;
        return d;
    }

    private void toPostfix(Stack stack, StringBuffer stringBuffer, String string, int n) {
        EvaluateData evaluateData;
        int n2 = 0;
        if (string != null) {
            n2 = ((EvaluateData)this.hash.get((Object)string)).operator;
        }
        while (!stack.empty()) {
            evaluateData = (EvaluateData)stack.peek();
            if (n2 == 2) {
                if (n > evaluateData.priority) break;
                evaluateData = (EvaluateData)stack.pop();
                stringBuffer.append(evaluateData.name + ' ');
                continue;
            }
            if (n >= evaluateData.priority) break;
            evaluateData = (EvaluateData)stack.pop();
            stringBuffer.append(evaluateData.name + ' ');
        }
        if (string != null) {
            evaluateData = (EvaluateData)this.hash.get(string);
            stack.push(new EvaluateData(evaluateData.name, n, evaluateData.operator, evaluateData.id));
        }
    }

    public void analysis() {
        int n = 4;
        int n2 = 0;
        int n3 = 5;
        Stack stack = new Stack();
        StringBuffer stringBuffer = new StringBuffer();
        EvaluateData evaluateData = (EvaluateData)this.hash.get("*");
        int n4 = 0;
        while (n4 < this.expression.length()) {
            char c = this.expression.charAt(n4);
            switch (this.classify(c)) {
                case 16: {
                    int n5;
                    n4 = n5 = this.skipSpace(this.expression, n4);
                    break;
                }
                case 2: {
                    int n5 = this.findLetter(this.expression, n4);
                    String string = this.expression.substring(n4, n5);
                    EvaluateData evaluateData2 = (EvaluateData)this.hash.get(string);
                    if (evaluateData2 == null) {
                        this.MethodError(string);
                    }
                    if (n != 4) {
                        if (evaluateData2.operator == 1 || evaluateData2.operator == 0) {
                            if (n == 1 && evaluateData2.operator == 0) {
                                this.toPostfix(stack, stringBuffer, evaluateData.name, 20 + n2);
                            } else {
                                this.toPostfix(stack, stringBuffer, evaluateData.name, evaluateData.priority + n2);
                            }
                        }
                    } else if (evaluateData2.operator == 2) {
                        this.SyntaxError(evaluateData2.name);
                    }
                    this.toPostfix(stack, stringBuffer, evaluateData2.name, evaluateData2.priority + n2);
                    n4 = n5;
                    if (evaluateData2.operator == 0) {
                        n = 2;
                        break;
                    }
                    n = 4;
                    break;
                }
                case 1: {
                    int n5 = this.findNumber(this.expression, n4);
                    stringBuffer.append(this.expression.substring(n4, n5) + ' ');
                    n4 = n5;
                    n = 1;
                    break;
                }
                case 32: {
                    int n5 = this.findOperator(this.expression, n4);
                    String string = this.expression.substring(n4, n5);
                    EvaluateData evaluateData2 = (EvaluateData)this.hash.get(string);
                    if (evaluateData2 == null) {
                        this.MethodError(string);
                    }
                    if (n == 2 || n == 1) {
                        this.toPostfix(stack, stringBuffer, evaluateData2.name, evaluateData2.priority + n2);
                    } else if (!"+".equals(evaluateData2.name)) {
                        if ("-".equals(evaluateData2.name)) {
                            int n6 = this.skipSpace(this.expression, n5);
                            evaluateData2 = (EvaluateData)this.hash.get("neg");
                            this.toPostfix(stack, stringBuffer, evaluateData2.name, evaluateData2.priority + n2);
                        } else {
                            this.SyntaxError(evaluateData2.name);
                        }
                    }
                    n4 = n5;
                    n = 4;
                    break;
                }
                case 4: {
                    if (n == 2 || n == 1) {
                        this.toPostfix(stack, stringBuffer, evaluateData.name, evaluateData.priority + n2);
                    }
                    n3 = !stack.empty() ? ((EvaluateData)stack.peek()).priority : 5;
                    n2 += 40;
                    n = 4;
                    ++n4;
                    break;
                }
                case 8: {
                    if ((n2 -= 40) < 0) {
                        this.SyntaxError(")");
                    }
                    n = 2;
                    this.toPostfix(stack, stringBuffer, null, n3);
                    ++n4;
                    break;
                }
            }
        }
        this.toPostfix(stack, stringBuffer, null, 5);
        if (stack.size() != 0) {
            this.SyntaxError(null);
        } else {
            this.errorMessage = "No error !";
        }
        this.postfix = stringBuffer.toString();
    }

    private int findNumber(String string, int n) {
        boolean bl = false;
        char c = string.charAt(n);
        int n2 = n;
        while (n2 < string.length()) {
            c = string.charAt(n2);
            if (!Character.isDigit(c)) break;
            ++n2;
        }
        if (c == '.') {
            ++n2;
            while (n2 < string.length()) {
                c = string.charAt(n2);
                if (!Character.isDigit(c)) break;
                ++n2;
            }
        }
        if (c == 'e') {
            if ((c = string.charAt(++n2)) != '+' && c != '-' && !Character.isDigit(c)) {
                bl = true;
            } else {
                ++n2;
                while (n2 < string.length()) {
                    c = string.charAt(n2);
                    if (!Character.isDigit(c)) break;
                    ++n2;
                }
            }
        }
        if (bl) {
            this.SyntaxError(string.substring(n, n2));
        }
        return n2;
    }

    private int findLetter(String string, int n) {
        int n2 = n;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (!Character.isLetter(c)) break;
            ++n2;
        }
        return n2;
    }

    private int skipSpace(String string, int n) {
        int n2 = n;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (!Character.isWhitespace(c)) break;
            ++n2;
        }
        return n2;
    }

    private int findOperator(String string, int n) {
        int n2 = n;
        char c = string.charAt(n2);
        if (this.hash.containsKey(String.valueOf(c))) {
            return n2 + 1;
        }
        return n2 + 1;
    }

    public Evaluate() {
        int n = 0;
        this.functionTable = new EvaluateData[20];
        this.functionTable[n++] = new EvaluateData("sin", 20, 1, 15);
        this.functionTable[n++] = new EvaluateData("cos", 20, 1, 5);
        this.functionTable[n++] = new EvaluateData("tan", 20, 1, 18);
        this.functionTable[n++] = new EvaluateData("exp", 20, 1, 7);
        this.functionTable[n++] = new EvaluateData("asin", 20, 1, 3);
        this.functionTable[n++] = new EvaluateData("acos", 20, 1, 0);
        this.functionTable[n++] = new EvaluateData("atan", 20, 1, 4);
        this.functionTable[n++] = new EvaluateData("ln", 20, 1, 8);
        this.functionTable[n++] = new EvaluateData("sqrt", 20, 1, 16);
        this.functionTable[n++] = new EvaluateData("^", 20, 2, 13);
        this.functionTable[n++] = new EvaluateData("pi", 35, 0, 14);
        this.functionTable[n++] = new EvaluateData("log", 20, 1, 9);
        this.functionTable[n++] = new EvaluateData("x", 35, 0, 19);
        this.functionTable[n++] = new EvaluateData("ans", 35, 0, 2);
        this.functionTable[n++] = new EvaluateData("mod", 20, 2, 10);
        this.functionTable[n++] = new EvaluateData("neg", 20, 1, 12);
        this.functionTable[n++] = new EvaluateData("+", 10, 2, 1);
        this.functionTable[n++] = new EvaluateData("-", 10, 2, 17);
        this.functionTable[n++] = new EvaluateData("/", 15, 2, 6);
        this.functionTable[n++] = new EvaluateData("*", 15, 2, 11);
        this.hash = new Hashtable(30);
        n = 0;
        while (n < 20) {
            this.hash.put(this.functionTable[n].name, this.functionTable[n]);
            ++n;
        }
    }

    public Evaluate(String string) {
        this();
        this.setExpression(string);
    }
}

